import numpy as np

def graph_generate(data_nums, graph_density, seeds = np.random.randint(0, 1000), v_nums = None):
    #generate random graph
    variable_nums = np.random.randint(6, 11) if v_nums is None else v_nums
    np.random.seed(seeds)
    Graph = np.zeros([variable_nums, variable_nums])
    edge_nums = int(0.5 * (variable_nums ** 2) - variable_nums)
    edge_list = []
    for i in np.arange(0, variable_nums):
        for j in np.arange(i+1, variable_nums):
            edge_list.append([i, j])
    edge_list = np.array(edge_list)
    n = edge_list.shape[0]
    selected_idx = np.random.choice(np.arange(n), size=int(graph_density*edge_nums), replace=False)
    edges_selected = edge_list[selected_idx]
    for [i, j] in edges_selected:
        Graph[i, j] = -1; Graph[j, i] = 1
    return generate_data(Graph, data_nums, seeds = seeds)

def generate_data(G, data_nums, seeds):
    # generate random relationship
    np.random.seed(seeds)
    assert G.shape[0] == G.shape[1]
    variable_nums = G.shape[-1]
    func_dic = {1: 'np.sin', 2: 'np.cos', 3: 'np.tanh'}
    Data = {}
    for i in range(0, variable_nums):
        Data[i] = np.array([])
    leaf_idx = []
    for i in range(0, variable_nums):
        if np.max(G[i]) < 1:
            if(np.random.randint(0, 2) == 0):
                Data[i] = np.random.randn(data_nums, 1)
            else:
                Data[i] = np.random.random((data_nums, 1)) - 0.5
            leaf_idx.append(i)
    no_leaf_node_idx = np.setdiff1d(np.arange(0, variable_nums), np.array(leaf_idx))

    for j in no_leaf_node_idx:
        PA = np.where(G[:, j] == -1)[0]
        nums_PA = PA.shape[0]
        func_id_f = np.random.randint(0, 4)
        func_id_g = np.random.randint(0, 5)
        noise_id = np.random.randint(0, 2)
        for i in range(nums_PA):
            if(i == 0):
                PA_Data = Data[PA[i]]
            else:
                PA_Data = np.concatenate((PA_Data, Data[PA[i]]), axis=1)

        Data_changed = np.matmul(PA_Data,np.ones((PA_Data.shape[-1], 1)))
        if(func_id_f == 0):
            Data[j] = 1.7*Data_changed/(PA_Data.shape[-1]+1)
        else:
            Data[j] = eval(func_dic[func_id_f])(Data_changed)
        if(noise_id == 0):
            Data[j] += 0.5*np.random.randn(data_nums, 1)
        else:
            Data[j] += 0.5*(np.random.random((data_nums, 1)) - 0.5)

        if(func_id_g == 0):
            Data[j] += 2.5*np.random.randn(data_nums, 1)
        elif(func_id_g == 1):
            Data[j] += np.exp(Data[j])
        else:
            power = np.random.randint(1, 4)
            Data[j] = np.power(Data[j], power)

    for i in range(0, variable_nums):
        if i == 0:
            data_mat = Data[0]
        else:
            data_mat = np.concatenate((data_mat, Data[i]), axis=1)

    Data['G'] = G
    Data['threshold'] = 0.002
    Data['data_mat'] = data_mat
    return Data

if __name__ == '__main__':
    d = graph_generate(500, 0.5, 5)
    print(d['data_mat'].shape)
